﻿using System;
using System.Web;
using System.Text;
using System.Security.Cryptography;

namespace UseResponseSso.Helpers
{
    class UseresponseSso
    {
        protected string source;
        protected string domain;
        protected string secret;
        protected string fullName;
        protected string email;
		protected string emailOriginal;
        protected string userId;
		protected string userIdOriginal;

        public UseresponseSso(string communityDomain, string secretKey, string userFullName, string userEmail, string userId)
        {
            this.domain = communityDomain;
            this.secret = secretKey;
            this.fullName = userFullName;
            this.email = userEmail;
			this.emailOriginal = userEmail;
            this.userId = userId;
			this.userIdOriginal = userId;
            this.source = HttpContext.Current.Request.ServerVariables["SERVER_NAME"];
        }
		
		public void SetTenant(string tenant)
        {
            this.email = this.emailOriginal.Replace("@", "+" + tenant + "@");
            this.userId = tenant + "_" + this.userIdOriginal;
        }

        public void SetIntegrationDomain(string integrationDomain)
        {
            this.source = integrationDomain;
        }

        public void Login(string redirectUrl)
        {
            HttpContext.Current.Response.Redirect(this.GetLoginUrl() + "?redirect=" + this.Encrypt(redirectUrl, this.secret));
        }

        public string GetCommunityDomain()
        {
            return this.domain;
        }

        public string GetLoginUrl()
        {
            return this.domain + "/sso/" +
                this.Encrypt(this.source, this.secret) + "/" +
                this.Encrypt(this.fullName, this.secret) + "/" +
                this.Encrypt(this.email, this.secret) + "/" +
                this.Encrypt(this.userId, this.secret) + "/" +
                this.GenerateHash() + "/direct-sso";
        }
		
		public string GetSdkToken()
        {
            return this.Encrypt(this.source, this.secret) + "/" +
                this.Encrypt(this.fullName, this.secret) + "/" +
                this.Encrypt(this.email, this.secret) + "/" +
                this.Encrypt(this.userId, this.secret) + "/" +
                this.GenerateHash();
        }

        protected string Encrypt(string str, string key)
        {
            key = this.Sha1(key);
            byte[] strBytes = Encoding.UTF8.GetBytes(str);
            int strLength = strBytes.Length;
            int keyLength = key.Length;
            int j = 0;
            string hash = "";
            byte ordStr;
            byte ordKey;

            for (int i = 0; i < strLength; i++)
            {
                ordStr = strBytes[i];

                if (j == keyLength)
                {
                    j = 0;
                }

                ordKey = Convert.ToByte(key.Substring(j, 1)[0]);
                j++;

                hash += this.Reverse(this.DecToAny(ordStr + ordKey, 36));
            }

            return hash;
        }

        protected string GenerateHash()
        {
            string key = this.Sha1(this.Md5(this.Reverse(this.secret)));
            string hashable = this.fullName + key + this.userId + key + this.email + key + this.source;

            return this.Sha1Bytes(this.ReverseAsBytes(hashable));
        }

        protected string Sha1(string input)
        {
            using (SHA1Managed sha1 = new SHA1Managed())
            {
                var hash = sha1.ComputeHash(Encoding.UTF8.GetBytes(input));
                var sb = new StringBuilder(hash.Length * 2);

                foreach (byte b in hash)
                {
                    sb.Append(b.ToString("x2"));
                }

                return sb.ToString();
            }
        }

        protected string Sha1Bytes(byte[] input)
        {
            using (SHA1Managed sha1 = new SHA1Managed())
            {
                var hash = sha1.ComputeHash(input);
                var sb = new StringBuilder(hash.Length * 2);

                foreach (byte b in hash)
                {
                    sb.Append(b.ToString("x2"));
                }

                return sb.ToString();
            }
        }

        protected string Md5(string input)
        {
            byte[] data = MD5.Create().ComputeHash(Encoding.UTF8.GetBytes(input));
            StringBuilder sBuilder = new StringBuilder();

            for (int i = 0; i < data.Length; i++)
            {
                sBuilder.Append(data[i].ToString("x2"));
            }

            return sBuilder.ToString();
        }

        protected string Reverse(string str)
        {
            byte[] byteArray = Encoding.UTF8.GetBytes(str);
            char[] charArray = new char[byteArray.Length];

            for (int i = 0; i < byteArray.Length; i++)
            {
                charArray[i] = Convert.ToChar(byteArray[i]);
            }

            Array.Reverse(charArray);

            return new string(charArray);
        }

        protected byte[] ReverseAsBytes(string str)
        {
            byte[] byteArray = Encoding.UTF8.GetBytes(str);

            Array.Reverse(byteArray);

            return byteArray;
        }

        protected string DecToAny(long decimalNumber, int radix)
        {
            const int BitsInLong = 64;
            const string Digits = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

            if (radix < 2 || radix > Digits.Length)
                throw new ArgumentException("The radix must be >= 2 and <= " +
                    Digits.Length.ToString());

            if (decimalNumber == 0)
                return "0";

            int index = BitsInLong - 1;
            long currentNumber = Math.Abs(decimalNumber);
            char[] charArray = new char[BitsInLong];

            while (currentNumber != 0)
            {
                int remainder = (int)(currentNumber % radix);
                charArray[index--] = Digits[remainder];
                currentNumber = currentNumber / radix;
            }

            string result = new String(charArray, index + 1, BitsInLong - index - 1);
            if (decimalNumber < 0)
            {
                result = "-" + result;
            }

            return result.ToLower();
        }
    }
}