<?php
/**
 * WARNING!
 * Do not edit this file directly!
 */

if (!defined('CACHE_PATH')) {
    define('CACHE_PATH', ROOT_PATH . '/cache');
}

$bootstrap = array(

    /* PHP directives */
    'phpSettings' => array(
        'display_startup_errors' => 1,
        'display_errors'         => 1
    ),

    'perfomance_test' => false,

    'on_cloud' => false,

    'protocol_less_urls' => false,

    'debug' => [
        'debugbarEnabled'           => false,
        'errorPageExceptionEnabled' => false
    ],

    /* CDN configuration */
    'cdn' => [
        'enabled' => false,
        'baseUrl' => null
    ],

    'assets' => [
        'minify'       => true,
        'deflate'      => false,
        'auto_rebuild' => true
    ],

    'filesystem' => [
        'public' => function () {
            return new League\Flysystem\Filesystem(new League\Flysystem\Adapter\Local(PUBLIC_PATH));
        },
        'app' => function () {
            return new League\Flysystem\Filesystem(new Useresponse\Filesystem\Adapter\Local(APPLICATION_PATH));
        },
        'static' => function () {
            return new League\Flysystem\Filesystem(new Useresponse\Filesystem\Adapter\Local(STATIC_PATH));
        }
    ],

    'services' => [
        '\Useresponse\Triggers\ServiceProvider'
    ],

    'cache' => [
        'default' => function () {

        }
    ],

    'gearman' => [
        'servers' => []
    ],

    'social' => [
        'facebook' => [
            'app_id'      => null,
            'app_secret'  => null,
            'permissions' => [
                'public_profile', 'manage_pages', 'email', 'read_page_mailboxes', 'publish_pages'
            ]
        ],
        'twitter'  => [
            'consumer_key'    => '',
            'consumer_secret' => ''
        ]
    ],

    'webpush' => [
        'ttl'          => 300,
        'ttl_internal' => 86400,
        'broker_url'   => 'https://www.useresponse.com/essentials/webpush/notifier.php',
        'vendors'      => [
            'chrome'  => [
                'endpoint'   => 'https://fcm.googleapis.com/fcm/send/',
                'server_key' => 'AAAApi9vC4Y:APA91bHR-_H6EVq9AoGs-AAH4nvy_mL3ITAVoeDNleHBdB8Tw75O82Rp9nGlLlGpbPsRUyFO5XelI00gdsQMUHEpNzHziG9p5ub_6NpAYXJ9IKXfyjeY5K3D5BlDhtcwhHo1N2FMj-G1',
                'sender_id'  => '713760377734',
                'use_broker' => true
            ],
            'firefox' => [
                'endpoint' => 'https://updates.push.services.mozilla.com/wpush/v1/'
            ]
        ]
    ],

    'jssdk' => [
        'resources'    => [
            'cache' => true
        ],
        'cloud'        => [
            'use_compiler' => true
        ],
        'use_compiler' => true
    ],

    'extra' => [
        'feedback' => [
            'allow_anonymous_comments' => false
        ]
    ],

    /* Application resources */
    'resources' => array(

        /* Database */
        'db' => array(
            'adapter' => 'pdo_mysql',
            'params'  => array(
                'host'        => 'localhost',
                'port'        => 3306,
                'dbname'      => '',
                'username'    => '',
                'password'    => '',
                'prefix'      => 'sglr_',
                'persistent'  => false,
                'profiler' =>
                array (
                  'enabled' => false,
                  'class'   => 'Zend_Db_Profiler_Firebug'
                ),
                //'charset'     => 'utf8',
                'date_format' => 'YYYY-MM-ddTHH:mm:ss',
                'options' => array(
                    'caseFolding'          => false,
                    'autoQuoteIdentifiers' => true
                ),
                'driver_options' => array(
                    /*PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true,*/
                    1006 => true,
                    1005 => 5
                )
            ),
            'isDefaultTableAdapter' => true
        ),

        /* Session */
        'session' => array(
            'name'                => SESSION_NAME,
            'remember_me_seconds' => 864000,
            'use_only_cookies'    => true,
            'strict'              => 'on',
            'use_db_storage'      => true
        ),

        /* Date */
        'date' => array(
            // php, iso
            'format_type' => 'php',
            'enable'      => true
        ),

        /* ACL */
        'acl' => array(
            'enable' => true,
            'error'  => array(
                'moduleName'     => 'system',
                'controllerName' => 'error',
                'actionName'     => 'access-denied'
            ),
            'navigationInject' => true,
            // seconds
            'allowed_edit_time' => 3600,
        ),

        /* Auth */
        'auth' => array(
            'table_name'        => 'users',
            'columns'           => array(
                'identity'    => 'email',
                'credential'  => 'password',
                'check_field' => 'state'
            ),
            'check_field_value' => '1',
            'enable'            => true
        ),

        /* FrontController */
        'frontController' => array(
            'moduleDirectory'               => array(
                MODULES_PATH,
                CUSTOM_MODULES_PATH
            ),
            'moduleControllerDirectoryName' => 'controllers',
            'defaultModule'                 => 'system',
            'defaultControllerName'         => 'index',
            'defaultAction'                 => 'index',
            'baseUrl'                       => '/',
            'followProxy'                   => false,
            'throwExceptions'               => false,
            'params' => array(
                'disableOutputBuffering' => true
            ),
            'actionHelperPaths' => array(
                'Singular_Controller_Action_Helper_' => 'Singular/Controller/Action/Helper'
            ),
            'plugins' => array(
                'errorhandler' => array(
                    'classname' => 'Zend_Controller_Plugin_ErrorHandler',
                    'options'   => array(
                        'module'     => 'system',
                        'controller' => 'error',
                        'action'     => 'error'
                    )
                ),
                'Singular_Controller_Plugin_Layout',
                'Singular_Controller_Plugin_AppClient',
                'Singular_Controller_Plugin_Quotes',
                /*'Singular_Controller_Plugin_Debug',*/
                'Singular_Controller_Plugin_Themes',
                'Singular_Controller_Plugin_Events',
                'Singular_Controller_Plugin_Debugbar',
                'Singular_Controller_Plugin_Output',
                'System_Controller_Plugin_Api',
            )
        ),

        /* Router */
        'router' => array(
            'routes' => array(
                'default' => array(
                    'type'     => 'Zend_Controller_Router_Route',
                    'route'    => '/',
                    'defaults' => array(
                        'module'     => 'system',
                        'controller' => 'index',
                        'action'     => 'index'
                    )
                )
            ),
            //'useRequestParametersAsGlobal' => false
        ),

        /* Autoloader */
        'autoloader' => array(
            'autoloader' => 'Singular',

            /* Singular autoloader */
            'singular'   => array(
                'cache'  => array(
                    'enable'   => true,
                    /* frontend */
                    'frontend' => array(
                        'name'                 => 'Core',
                        'customFrontendNaming' => false,
                        'options' => array(
                            'lifetime'                => 864000,
                            'automatic_serialization' => true,
                            'cache_id_prefix'         => 'autoloader_',
                            'ignore_user_abort'       => true
                        )
                    ),
                    /* backend */
                    'backend'  => array(
                        'name'                => 'File',
                        'customBackendNaming' => false,
                        'options' => array(
                            'cache_dir'                  => CACHE_PATH,
                            'hashed_directory_level'     => 0,
                            'read_control'               => false,
                            'read_control_type'          => 'adler32',
                            'metatadatas_array_max_size' => 10

                        )
                    ),
                    'frontendBackendAutoload' => false
                )
            ),

            /* Zend autoloader */
            'zend' => array(
                'params' => array(
                    'enableFallbackAutoloader' => true,
                    'suppressNotFoundWarnings' => false,
                    'noZendX' => true,
                ),
                'registry_key' => 'autoloader',
                'modules' => array(
                    'system'
                )
            )
        ),

        /* Cachemanager */
        'cachemanager' => array(
            'globalCacheEnabled' => false,

            /* default cache */
            'default' => array(
                /* frontend */
                'frontend' => array(
                    'name'                 => 'Core',
                    'customFrontendNaming' => false,
                    'options' => array(
                        'caching'                 => true,
                        'lifetime'                => 864000,
                        'automatic_serialization' => true,
                        'cache_id_prefix'         => 'default_',
                        'ignore_user_abort'       => true,
                        'write_сontrol'           => false
                    )
                ),
                /* backend */
                'backend'  => array(
                    'name'                => 'File',
                    'customBackendNaming' => false,
                    'options' => array(
                        'cache_dir'                  => CACHE_PATH,
                        'hashed_directory_level'     => 1,
                        'read_control'               => false,
                        'read_control_type'          => 'strlen',
                        //'metatadatas_array_max_size' => 1000,
                    )
                ),
                'frontendBackendAutoload' => false
            ),

            /* view cache */
            'view' => array(
                /* frontend */
                'frontend' => array(
                    'name'                 => 'Output',
                    'customFrontendNaming' => false,
                    'options' => array(
                        'caching'                 => true,
                        'lifetime'                => 864000,
                        'automatic_serialization' => true,
                        'cache_id_prefix'         => 'view_',
                        'ignore_user_abort'       => true,
                        'write_сontrol'           => false,
                    )
                ),
                /* backend */
                'backend'  => array(
                    'name'                => 'File',
                    'customBackendNaming' => false,
                    'options' => array(
                        'cache_dir'                  => CACHE_PATH,
                        'hashed_directory_level'     => 1,
                        'read_control'               => false,
                        'read_control_type'          => 'strlen',
                        //'metatadatas_array_max_size' => 1000,
                    )
                ),
                'frontendBackendAutoload' => false
            ),
        ),

        /* View */
        'view' => array(
            'encoding'            => 'utf-8',
            'setUseStreamWrapper' => false,
            'strictVars'          => true,
            'escape'              => 'htmlentities',
            'scriptPath'          => APPLICATION_PATH . '/templates',
            'helperPath'          => array('Singular_View_Helper_' => 'Singular/View/Helper'),
            'filterPath'          => array('Singular_View_Helper_' => 'Singular/View/Filter'),
            'doctype'             => 'HTML5'/* XHTML1_TRANSITIONAL */,
            'debug'               => false
        ),

        /* Layout */
        'layout' => array(
            'layoutPath' => APPLICATION_PATH . '/layouts',
            'layout'     => 'main',
            'contentKey' => 'content'
        ),

        /* Locale */
        'locale' => array(
            'enable' => true
        ),

        /* Languages */
        'languages' => array(
            'enable' => true
        ),

        /* Modules */
        'modules' => array(
            'autodiscover' => true,
            'default'      => array(
                'system'
            )
        ),

        /* Navigation */
        'navigation' => array(
            'defaultPageType' => 'mvc',
            'pages'           => array(),
            'storage'         => array(
                'registry' => true
            ),
            'enable' => true
        ),

        /* Translate */
        'translate' => array(
            'adapter' => 'array',
            'options' => array(
                'disableNotices'  => false,
                'scan'            => 'filename',
                'clear'           => false,
                'reload'          => false,
                'ignore'          => '.',
                'logUntranslated' => false
            ),
            'isDefaultValidateTranslator' => true,
            'isDefaultFormTranslator'     => true,
            'isDefaultRouterTranslator'   => false,
            'cookie_expire'               => 31536000, // one year
            'defaultLanguage'             => 'en'
        ),

        /* Events */
        'event' => array(
            'handlersDirectoryName' => 'handlers',
            'throwExceptions'       => false
        ),

        /* Output */
        'minify' => array(
            'enable'               => false,
        ),

        /* Zend framework debug toolbar */
        'zfdebug' => array(
            'enabled' => false,
            'z-index' => 100000000,
            'plugins' => array(
                'Variables' => null,
                'Time'      => null,
                'Memory'    => null,
                'Html'      => null,
                'Registry'  => null,
                'Exception' => null
            )
        ),

        /* Features management. */
        'features' => array()
    ),

    /* Directories */
    'directories' => array(
        'vendors' => ROOT_PATH . '/vendors'
    ),

    /* htmlElement */
    'htmlElement' => array(
        'assetsPath'        => 'application/' . APPLICATION_VERSION . '/assets',
        'assetsPathModules' => 'application/' . APPLICATION_VERSION . '/modules',
        'assetsPathThemes'  => 'assets',
        'imageDirName'      => 'images',
        'flashDirName'      => 'flash',
        'stylesheetDirName' => 'css',
        'javascriptDirName' => 'js',
        'commonDirName'     => 'common',
        'checkExistence'    => false
    ),

    'pageDefaults' => array(
        'frontend' => array(
            'javascriptFile' => 'frontend.js',
            'stylesheetFile' => 'frontend.css'
        ),
        'admin' => array(
            'javascriptFile' => 'admin.js',
            'stylesheetFile' => 'admin.css',
        )
    ),

    /* Optional Features */
    'features' => [],

    /* Live Chat */
    'chat' => [
        'debug'  => false,
        'server' => [
            'host'   => 'chat.useresponse.com',
            'port'   => 443,
            'secure' => true,
            'wsPath' => '/ws',
        ]
    ]
);

return $bootstrap;
