<?php
/**************************************************************
 * Copyright USWebStyle Inc., 2011-2012. All Rights Reserved.
 **************************************************************
 * NOTICE:  This source code is the property of USWebStyle, Inc.
 * In no case shall you rent, lease, lend, redistribute
 * any of below source code to a 3rd party individual or entity.
 *
 * @category   Resources
 * @package    Resources_Controller
 * @copyright  USWebStyle Inc., 2011-2012 (http://www.uswebstyle.com)
 * @license    http:/www.useresponse.com/licensing (Commercial)
 */

/**
 * AdminMailing controller
 *
 * @uses       System_Controller_Abstract_Admin
 * @category   Resources
 * @package    Resources_Controller
 */
class Resources_AdminMailingController extends System_Controller_Abstract_Admin
{
    /**
     * Changes mailing settings
     *
     * @return void
     */
    public function editAction()
    {
        $form = new Resources_Form_Mailing($this->settings->system->mailing);
        if ($this->getRequest()->isPost()) {
            $post = $this->getRequest()->getPost();
            if ($post['email_connection_type'] != 'smtp') {
                foreach ($form as $element) {
                    if (preg_match("/^email_smtp/", $element->getName())) {
                        $element->setAllowEmpty(true);
                    }
                }
            }
            if ($form->isValid($post)) {
                $data = $form->getValues();
                foreach ($data as $key => $value) {
                    Singular_Core::_('settings')->changeSetting($key, $value);
                }
                $this->view->notify()->success('Mailing settings are changed!');
            }
        }
        $this->view->form = $form;
    }

    /**
     * Makes test connection for verifying mailing settings
     *
     * @return void
     */
    public function testConnectionAction()
    {
        if (!$this->isAjax()) {
            throw new Zend_Exception("Only XmlHttpRequest request");
        }
        if ($this->getRequest()->isPost()) {
            $smtp = $this->_getParam('smtp');
            $config = array();
            if ($smtp['auth']) {
                $config = array(
                    'auth'     => 'login',
                    'username' => $smtp['username'],
                    'password' => $smtp['password']
                );
                if ($smtp['security'] != 'off') {
                    $config['ssl'] = $smtp['security'];
                }
            }
            try {
                $connectionClass = 'Zend_Mail_Protocol_Smtp';
                if (isset($config['auth'])) {
                    $connectionClass .= '_Auth_' . ucfirst($config['auth']);
                }
                /** @var $connection Zend_Mail_Protocol_Smtp */
                $connection = new $connectionClass($smtp['host'],
                    $smtp['port'], $config
                );
                $connection->connect();
                $connection->helo();
                $this->autoresponder->setSuccess('Connection works!');
            } catch (Zend_Mail_Protocol_Exception $e) {
                $this->autoresponder->setError('Connection failed!');
            }
        } else {
            $this->autoresponder->setError('Bad request');
        }
    }
}
