<?php
/**************************************************************
 * Copyright UseResponse Inc., 2012-2016. All Rights Reserved.
 **************************************************************
 * NOTICE:  This source code is the property of UseResponse Inc.
 * In no case shall you rent, lease, lend, redistribute
 * any of below source code to a 3rd party individual or entity.
 *
 * @category   Resources
 * @package    Resources_View
 * @subpackage Resources_View_Helper
 * @copyright  UseResponse Inc., 2012-2016 (https://www.useresponse.com)
 * @license    https://www.useresponse.com/eula_license-agreement (Commercial)
 */

/**
 * CommentInfo view helper
 *
 * @uses       Zend_View_Helper_Abstract
 * @category   Resources
 * @package    Resources_View
 * @subpackage Resources_View_Helper
 */
class Resources_View_Helper_MergedObjects extends Zend_View_Helper_Abstract
{
    /**
     * Returns merged objects
     *
     * @param  System_Model_Object $object
     *
     * @return string
     */
    public function mergedObjects($object)
    {
        if (!$object instanceof System_Model_Object) {
            return "";
        }

        $mergesList = Resources_Service_Merger::findByObject($object);

        if (count($mergesList) > 0) {
            $this->view->assign(
                array(
                    'merges' => $mergesList
                )
            );
            $this->view->additionalModulePath('resources');
            return $this->view->render('merges.phtml');
        }

        return '';
    }
}
