<?php
/**************************************************************
 * Copyright USWebStyle Inc., 2011-2012. All Rights Reserved.
 **************************************************************
 * NOTICE:  This source code is the property of USWebStyle, Inc.
 * In no case shall you rent, lease, lend, redistribute
 * any of below source code to a 3rd party individual or entity.
 *
 * @category   Categories
 * @package    Categories_Model
 * @subpackage Categories_Model_DbTable
 * @copyright  USWebStyle Inc., 2011-2012 (http://www.uswebstyle.com)
 * @license    http:/www.useresponse.com/licensing (Commercial)
 */

/**
 * Response Categories table model.
 *
 * @uses       System_Model_DbTable_Abstract
 * @category   Categories
 * @package    Categories_Model
 * @subpackage Categories_Model_DbTable
 */
class Categories_Model_DbTable_ResponsesCategories extends System_Model_DbTable_Abstract
{
    /**
     * Default fetch limit
     */
    const LIMIT = 10;

    /**
     * The table name
     *
     * @var string
     */
    protected $_name = 'response_categories';

    /**
     * The primary key column or columns.
     * A compound key should be declared as an array.
     * You may declare a single-column primary key
     * as a string.
     *
     * @var mixed
     */
    protected $_primary = 'id';

    /**
     * Row class
     *
     * @var string
     */
    protected $_rowClass = 'Categories_Model_ResponseCategory';

    /**
     * Reference map
     *
     * @var array
     */
    protected $_referenceMap = array(
        'Category' => array(
            'columns'       => array('category_id'),
            'refTableClass' => 'Categories_Model_DbTable_Categories',
            'refColumns'    => array('id'),
            'onDelete'      => self::CASCADE,
        ),
    );

    /**
     * Return total nubmer of categories.
     *
     * @param  array $where
     * @return int
     */
    public function count($where = null)
    {
        /** @var $select Zend_Db_Select */
        $select = $this->getSelect();
        if(is_array($where)){
            foreach($where as $cond => $value){
                if($value !== null){
                    $select->where($cond . '=?', $value);
                }
            }
        }
        $select->reset("columns");
        $select->columns(array('count' => new Zend_Db_Expr("COUNT(DISTINCT({$this->getTableName()}.id))")));
        $result = $this->fetchRow($select);
        return $result['count'];
    }

    /**
     * Return categories' ids by response id.
     *
     * @param  int $responseId
     * @return array
     */
    public function getCategoryIdsByResponseId($responseId)
    {
        $select = $this->select();
        $select->where('response_id=?', $responseId);

        return $this->getAdapter()->fetchPairs($select);
    }

    /**
     * Delete response by id.
     *
     * @param  int $responseId
     * @return void
     */
    public function deleteByResponseId($responseId)
    {
        $where = $this->getAdapter()->quoteInto('response_id=?', $responseId);
        $this->delete($where);
    }
}
