App.module.extend({
    system: {
        controllers: {
            index: {
                index: function() {
                    App.onReady(function(){
                        var titles = $(".title-block, .title-object:not(.knowledgeBase-hdr)");
                        titles.each(function () {
                            title = $(this);
                            if (title.next().hasClass('objects')) {
                                title.css("cursor", "pointer");
                                var href = title.next().find('a.all-objects').eq(0).attr('href');
                                title.on('click', function() {
                                    return window.location.href = href;
                                });
                            }
                        });

                        /* Find/Add block tabs */
                        $('.findAddObjects-tabs a').click(function(){
                            $('.findAddObjects-tabs a').removeClass('active');
                            $(this).addClass('active');
                            $('form#response-add').attr('action', $(this).attr('href'));
                            $("form#response-add p#info").show();
                            $("form#response-add p#empty").hide();
                            return false;
                        });
                        $("#response-add").submit(function(){
                            if ($(this).find(".textInput input").val() == '') {
                                $(this).find("p").html(App.t("Enter text to search response!")).css("color", "red");
                                return false;
                            }
                            $(".findAddObjects-tabs .active").click();
                            var input = $(".findAddObjects-input");
                            input.append('<i class="preloader right" style="padding-top:15px"></i>');
                            input.find('input').css('width', '95%');
                            input.find('i').show();
                            var searchPhrase = input.find('input').val().replace(/\//g, '-');
                            var url = App.baseUrl('quick/search/' + encodeURIComponent(searchPhrase));
                            App.remote.get(url, {'type':$(".findAddObjects-tabs .active").attr("id")}, function(r) {
                                result = App.remote.parseResult(r);
                                input.find(".preloader").remove();
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                var output = result.data.getOutput();
                                if (output) {
                                    button = $("#response-add #submit");
                                    button.hide();
                                    $("#reset-search").remove();
                                    button.after('<a id="reset-search" class="floatRight" href="#">' + App.t('Reset Search') + '</a>');
                                    $("#reset-search").click(function(){
                                        $("#response-add #submit").show();
                                        $(this).remove();
                                        $(".findAddObjects-input input").val("");
                                        $(".b-ur-tab-content").remove();
                                        return false;
                                    });
                                    $(".b-ur-tab-content").remove();
                                    $(".findAddObjects-block").after(output);
                                    
                                } else {
                                    location.href = App.baseUrl('response/add/' + $(".findAddObjects-tabs .active").attr("id") + '/?text=' + result.data.getParam('text'));
                                }
                            });
                            return false;
                        });
                    });
                }
            },
            response: {
                _init: function() {
                    App.onReady(function(){
                        $('.tellWhy').click(function(){
                            $('.leave-comment-content .resizer-wrap textarea').focus();
                            return false;
                        });
                    });
                },
                add: function () {
                    App.onReady(function () {
                        if (!App.getParam('mobileTheme')) {
                            $(window).on('beforeunload', function (e) {
                                if(e.target.activeElement.className === 'login'){
                                    return;
                                }
                                var textArea = $('textarea#ta_text');
                                if (textArea.val().length > 0 && !(textArea.val().length === 1 && textArea.val().charCodeAt(0) === 10)) {
                                    return (App.t('All changes you have made to this page will be lost!'));
                                }
                            });
                        }

                        $(".captcha .refresh").click(function(){
                            var image = $(this);
                            image.attr('src', App.baseUrl('/public/assets/images/preloader.gif'));
                            image.css("padding", "4px 0px 0px 9px");
                            var url = App.baseUrl('/response/add/reload-captcha');
                            App.remote.post(url, {}, function(r) {
                                result = App.remote.parseResult(r);
                                captcha = result.data.getParam('captcha');
                                $('.captcha-img img').attr('src', captcha.src);
                                $('#captcha-id').attr('value', captcha.id);
                                image.attr('src', App.baseUrl('/public/assets/images/icons/24/refresh.png'));
                                image.css("padding", "0px 0px 0px 5px");
                            });
                        });
                        $("#submit_guest_link").on(App.event.click(), function (event) {
                            var block = $(".anonymous-block");
                            if (block.is(":visible")) {
                                $(this).html(App.t('Anonymously'));
                                $(this).removeClass("back");
                                block.hide();
                                $("#as_guest").val('0');
                            } else {
                                if ($.browser.safari) {
                                    $('body').animate({scrollTop: 1000}, 1100);
                                } else {
                                    $('html').animate({scrollTop: 1000}, 1100);
                                }
                                $(this).html(App.t('Back'));
                                $(".anonymous-block").show();
                                $(this).addClass("back");
                                $("#as_guest").val('1');
                            }
                            return false;
                        });
                        $("#response-add").submit(function () {
                            $(window).unbind('beforeunload');
                            if (App.getParam("isGuest")) {
                                var params  = {'form_id': $(this).attr("id")},
                                    asGuest = $(this).find("#as_guest");
                                if (asGuest.length && asGuest.val() * 1) {
                                    return true;
                                }
                                App.openLoginPopup(params);
                                return false;
                            }
                        });
                    });
                },
                show: function () {
                    App.onReady(function () {
                        $('input[name=notify]').live('change', function(){
                            img = $(this).parent().find("img");
                            if ($(this).is(":checked")) {
                                img.attr('src', App.baseUrl('/public/assets/images/icons/16/notify_enabled.jpg'));
                            } else {
                                img.attr('src', App.baseUrl('/public/assets/images/icons/16/notify_disabled.jpg'));
                            }
                        });
                        
                        $(".responseTopActions a").on(App.event.click(), function(event) {
                            event.stopImmediatePropagation();
                            if ($(this).hasClass("activ-pos")) {
                                return false;
                            }
                            link = $(this);
                            text = link.html();
                            width = link.css("width");
                            link.css("width", width);
                            margin = (link.width()/2 - 8) + '';
                            link.html('<i class="preloader" style="margin-left:' + margin + 'px"></i>');
                            url = $(this).attr("href");
                            App.remote.post(url, {}, function(r) {
                                $('.horizontal li a.pos').removeClass('activ-pos');
                                link.addClass('activ-pos');
                                link.html(text);
                                link.css("width", "auto");
                                result = App.remote.parseResult(r);
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                App.notify.success(result.data.getMessage());
                            });
                            return false;
                        });

                        // Change response status
                        $("#select-response-status").change(function(){
                            form = $(this).closest('form');
                            url = form.attr("action");
                            data = {
                                'format' : 'json',
                                'status' : $(this).val()
                            };
                            form.find(".preloader").show();
                            App.remote.post(url, data, function(r) {
                                result = App.remote.parseResult(r);
                                form.find(".preloader").hide();
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                App.notify.success(result.data.getMessage());
                            });
                        });

                        // Like button on full respons
                        $('.buttons-object-full .iLikeIt, .buttons-object-full .iDont').on(App.event.click(), function (event) {
                            event.stopImmediatePropagation();
                            link = $(this);
                            if (!App.getParam("votes")) {
                                params = {'redirect' : $(this).attr("href")};
                                App.openLoginPopup(params);
                                return false;
                            }
                            if ($(this).hasClass("disactive")) {
                                return false;
                            }
                            if ($(this).hasClass("iDont") && !$(this).hasClass("notForce") && App.getParam("force_to_comment_negative_vote") == 1) {
                                form = $(".leave-comment");
                                if (form != void(0)) {
                                    form.find("#comment-add-is-negative").attr("checked","checked").change();
                                    form.find("#vote").val("-1");
                                    destination = form.offset().top;
                                    if($.browser.safari){
                                        $('body').animate( {scrollTop: destination}, 1100 );
                                    }else{
                                        $('html').animate( {scrollTop: destination}, 1100 );
                                    }
                                }
                                return false;
                            }
                            votes = $(".title-object-full .votes center");
                            votes2 = link.find(".vote-plus");
                            link.find(".how-like").addClass("loader");
                            App.remote.get(link.attr("href"), {format: 'json'}, function(r) {
                                result = App.remote.parseResult(r);
                                link.find(".how-like").removeClass("loader");
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                voteSum = result.data.getParam("voteSum");
                                disactive = link.parent().find(".disactive");
                                if (!disactive.length) {
                                    link.addClass("disactive");
                                    votes.html(voteSum.all);
                                    vote = (link.hasClass('iLikeIt')) ? voteSum.positive : voteSum.negative;
                                    votes2.html(vote);
                                } else {
                                    disactive.removeClass("disactive");
                                    vote = (disactive.hasClass('iDont')) ? voteSum.negative : voteSum.positive;
                                    disactive.find(".vote-plus").html(vote);
                                    vote = (link.hasClass('iLikeIt')) ? voteSum.positive : voteSum.negative;
                                    link.find(".vote-plus").html(vote);
                                    link.addClass("disactive");
                                }
                                $(document).trigger('response.voteAdded', [result.data]);
                                App.notify.success(result.data.getMessage());
                            });
                            return false;
                        });

                        $('#answer_delete').on(App.event.click(), function (event) {
                            var responseId = $('input[name="response_id"]').eq(0).val(),
                                url        = App.baseUrl('/responses/' + responseId + '/delete/answer');

                            if (confirm(App.t("Are you sure? You can't UNDO this operation!"))) {
                                location.href = url;
                            }
                        });
                    });
                }
            },
            auth : {
                registration: function() {
                    App.onReady(function() {
                        $("#system-form-registration #submit").click(function(){
                            $(this).parents("form").find(".preloader").show();
                            $(this).attr("disabled", "disabled");
                        })
                    });
                }
            },
            user : {
                _init: function() {
                    App.onReady(function(){
                        $("#user-delete").click(function(){
                            if (confirm(App.t("Are you sure? You can't UNDO this operation!"))) {
                                if (confirm(App.t("Do you want to delete responses and comments?"))) {
                                    location.href = App.baseUrl('users/' + App.getParam('activeUserId') + '/delete/all');
                                } else {
                                    location.href = App.baseUrl('users/' + App.getParam('activeUserId') + '/delete/user');
                                }
                            }
                            return false;
                        });
                        $(".banUser,.recoveryUser").click(function(){
                            link = $(this);
                            background = link.css("background-image");
                            link.addClass("loader");
                            App.remote.get(link.attr("href"), {format:'json'}, function(r) {
                                result = App.remote.parseResult(r);
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                link.removeClass("loader");
                                if (link.hasClass("banUser")) {
                                    link.removeClass("banUser").addClass("recoveryUser iaccept");
                                    link.html(App.t("Recover Access"));
                                    link.attr("href", App.baseUrl("/users/" + result.data.getParam("userId") + "/recovery"));
                                } else {
                                    link.removeClass("recoveryUser").addClass("banUser");
                                    link.html(App.t("Ban User"));
                                    link.attr("href", App.baseUrl("/users/" + result.data.getParam("userId") + "/ban"));
                                }
                                App.notify.success(result.data.getMessage());
                            });
                            return false;
                        });
                    });
                },
                index : function() {
                    App.onReady(function(){
                        $(".notSubscribe").live("click", function(){
                            link = $(this);
                            link.hide();
                            link.parent().find(".preloader").show().css("float", "right");
                            App.remote.get(link.attr("href"), {format:'json'}, function(r) {
                                result = App.remote.parseResult(r);
                                link.parent().find(".preloader").hide();
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                App.notify.success(result.data.getMessage());
                                if (link.hasClass("subscribed")) {
                                    link.removeClass("subscribed");
                                } else {
                                    link.addClass("subscribed");
                                }
                                output = result.data.getOutput();
                                link.attr("href", $(output).attr("href"));
                                link.attr("title", $(output).attr("title"));
                                link.show();
                            });
                            return false;
                        });
                    });
                },
                profile : function() {
                    App.onReady(function(){
                        $("#api-settings").click(function(){
                            block = $(".api-block");
                            if (block.is(':visible')) {
                                block.fadeOut();
                            } else {
                                block.fadeIn();
                            }
                        });
                        $("#change-password").on(App.event.click(), function (event) {
                            event.stopImmediatePropagation();
                            form = $(".change-password");
                            if (form.is(':visible')) {
                                form.fadeOut();
                            } else {
                                form.fadeIn();
                            }
                        });
                        $("input[type=file]").change(function(){
                            filename = this.value.replace(/^.*[\/\\]/g, "");
                            $(this).parent().parent().find("#file").val(filename);
                        });
                        $("#change-password-button").click(function(){
                            $(".change-password .preloader").css("float", "right").show()
                            data = {
                                format : 'json',
                                password : $("#password").val(),
                                password_again : $("#password_again").val(),
                                old_password : $("#old_password").val()
                            };
                            url = App.baseUrl('/profile/' + App.getParam('logged_user_id') + '/change-password');
                            App.remote.post(url, data, function(r){
                                $(".preloader").hide();
                                result = App.remote.parseResult(r);
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                $(".change-password").fadeOut();
                                $("#password").val('');
                                $("#password_again").val('');
                                $("#old_password").val('');
                                App.notify.success(result.data.getMessage());
                            });
                            return false;
                        });
                        $('#retrieve').click(function(){
                            src = App.get_gravatar($("#gravatar_email").val(), 50);
                            $('.gravatar img').attr('src', src);
                        });
                        $("input[name='config[send_notifications]']").click(function(){
                            if ($(this).val() == 'once') {
                                $("#time").fadeIn();
                            } else {
                                $("#time").fadeOut();
                            }
                        });
                        $("input[name='config[send_notifications]']:checked").click();

                        // Customer's license management
                        $('#license-manager').click(function(){
                            location.href = App.baseUrl("/license");
                        });

                        // Customer's migration-wizard
                        $('#migration-wizard').click(function(){
                            location.href = App.baseUrl("/migration");
                        });
                    });
                }
            },
            users : {
                _init : function () {
                    App.onReady(function(){
                        $("#search-people").focus(function(){
                            if ($(this).val() == App.t('Search People')) {
                                $(this).val('');
                            }
                        });
                        $("#search-people").focusout(function(){
                            if ($(this).val() == '') {
                                $(this).val(App.t('Search People'));
                            }
                        });
                    });
                },
                index : function() {
                    App.onReady(function(){
                        $(".sortByDate, .sortByRole").change(function(){
                            href = App.baseUrl('/users/paginator/' + $(".sortByDate").val() + '/' + $(".sortByRole").val());
                            searchPeople = $("#search-people").val();
                            if (searchPeople != '' && searchPeople != App.t('Search People')) {
                                href += '?search=' + searchPeople;
                            }                            
                            location.href = href;
                        });
                        $("#form-search-people").submit(function(){
                            searchPeople = $("#search-people").val();
                            if (searchPeople != '' && searchPeople != App.t('Search People')) {
                                location.href = App.baseUrl('/users/paginator/' + $(".sortByDate").val() + '/' + $(".sortByRole").val() + '?search=' + searchPeople);
                            }
                            return false;
                        });
                    });
                },
                paginator : function() {
                    App.onReady(function(){
                        paginator = function(){
                            if ($(".sortByDate").val() == 'default_view'
                                && $(".sortByRole").val() == 'all'
                                && ($("#search-people").val() == '' || $("#search-people").val() == App.t('Search People'))) {
                                location.href = App.baseUrl('/users');
                            } else {
                                url = App.baseUrl('/users/paginator/' + $(".sortByDate").val() + '/' + $(".sortByRole").val());
                                element = $(this);
                                if (element.is("select")) {
                                    filter = element.parent();
                                    filter.find(".preloader").css("float", "right").show();
                                } else {
                                    element.find(".search-block-submit")
                                           .addClass("preloader")
                                           .show()
                                           .css("margin", "2px");
                                }
                                App.remote.get(url, {format : 'json', search : $("#search-people").val() }, function(r){
                                    result = App.remote.parseResult(r);
                                    if (result.data.isError()) {
                                        App.notify.error(result.data.getMessage());
                                        return false;
                                    }
                                    if (element.is("select")) {
                                        filter.find(".preloader").hide();
                                    } else {
                                        element.find(".search-block-submit")
                                               .removeClass("preloader")
                                               .css("margin", "0px");;
                                    }
                                    $(".mainArea-type1.floatLeft").html(result.data.getOutput());
                                });
                            }
                            return false;
                        };
                        $("#form-search-people").submit(paginator);
                        $(".sortByDate, .sortByRole").change(paginator);
                    });
                }
            },
            widget : {
                index : function(){
                    App.onReady(function(){
                        
                        App.config.ajax.useDefaultEventHandlers = false;
                        
                        redirect = App.getParam("redirect");
                        if (redirect) {
                            parent.postMessage("redirect:url(" + redirect + ")", "*");
                        }
                        
                        // feedback widget
                        $('.new-topic-tabs li label').click(function(){
                            $('.new-topic-tabs li label .marker').remove();
                            $(this).append('<span style="display:block;" class="marker"></span>');
                        });

                        // make default tab selected
                        if (App.hasParam('widget_default_tab')) {
                            $('#' + App.getParam('widget_default_tab')).trigger('click').addClass('active');
                        }
                        
                        $(".search-block-submit").click(function(){
                            input = $("#title");
                            button = $(this);
                            if (input.val() == '' || input.val() == App.t('Title')) {
                                return false;
                            }
                            $type = $("input[name=type]:checked");
                            if ($type.length) {
                                type = $type.val();
                            } else {
                                type = 'all';
                            }
                            button.addClass('preloader').show().css('margin', '2px');
                            url = App.baseUrl('/quick/search/' + encodeURIComponent(input.val()));
                            App.remote.get(url, {'widget' : '1', 'type' : type}, function(r) {
                                result = App.remote.parseResult(r);
                                button.removeClass('preloader').css('margin', '0');
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                output = result.data.getOutput();
                                if (output) {
                                    content = $(".content");
                                    content.find(".objects").hide();
                                    content.append(output);
                                }
                            });
                            return false;
                        });
                        
                        $('#submit_guest_link').on(App.event.click(), function(event){
                            anonBlock = $(".anonymous-block");
                            title = $("#title");
                            desc = $("#ta_text");
                            if (anonBlock.is(":visible")) {
                                $(this).html(App.t('Anonymously'));
                                $(this).removeClass("back");
                                $("#response-add").find("*").show();
                                anonBlock.hide().find("*").hide();
                                $("#as_guest").val('0');
                            } else {
                                valid = true;
                                if (title.val() == '' || title.val() == App.t('Title')) {
                                    title.parent().addClass('error');
                                    valid = false;
                                }
                                if (desc.val() == '' || desc.val() == App.t('Description')) {
                                    desc.parent().addClass('error');
                                    valid = false;
                                }
                                if (valid === false) {
                                    return false;
                                }
                                $(this).html(App.t('Back'));
                                $("#response-add").find("*").hide();
                                anonBlock.show().find("*").show();
                                $(".other-block, .other-block *").show();
                                $(this).addClass("back");
                                $("#as_guest").val('1');
                            }
                            return false;
                        });
                        $("#response-add .contentInput textarea").focus(function(){
                            if ($(this).val() == App.t('Description')) {
                                $(this).css('color', '#252525');
                                $(this).val('');
                            }
                        }).blur(function(){
                            if ($(this).val() == '') {
                                $(this).css('color', '#959595');
                                $(this).val(App.t('Description'));
                            }                            
                        });
                        $("#title").focus(function(){
                            if ($(this).val() == App.t('Title')) {
                                $(this).css('color', '#252525');
                                $(this).val('');
                            }
                        }).blur(function(){
                            if ($(this).val() == '') {
                                $(this).css('color', '#959595');
                                $(this).val(App.t('Title'));
                            }                            
                        });
                        $("#response-add .textInput input").live('click', function(){
                            activeType = $(".new-topic-tabs .active");
                            if (activeType.length == 0) {
                                $(".new-topic-tabs li label").eq(0).click();
                                $(this).focus();
                            }
                        });
                        
                        $(".new-topic-tabs li label").click(function(){
                            $(".content .objects").hide();
                            $(".content #objects-" + $(this).attr("id")).show();
                        });
                        $("#response-add").submit(function(){
                            title = $("#title");
                            title.parent().removeClass('error');
                            desc = $("#ta_text");
                            desc.parent().removeClass('error');
                            valid = true;
                            if (title.val() == '' || title.val() == App.t('Title')) {
                                title.parent().addClass('error');
                                valid = false;
                            }
                            if (desc.val() == '' || desc.val() == App.t('Description')) {
                                desc.parent().addClass('error');
                                valid = false;
                            }
                            if (valid === false) {
                                return false;
                            }
                            if (App.getParam("isGuest")) {
                                asGuest = $(this).find("#as_guest");
                                if (asGuest.length && asGuest.val()*1) {
                                    return true;
                                }
                                $(".widget-adv-add-response").addClass("wide");
                                $(".widget-back").show();
                                $("#response-add").hide();
                                $(".widget-adv-responses").hide();
                                $(".login-inner").show();
                                $(".b-popup-tabs .itTab.selected a").click();
                                $(".auth-form form").each(function(){
                                    $(this).find(".hidden-params").remove();
                                    $(this).append("<input class='hidden-params' type='hidden' name='form_id' value='response-add' />");
                                });
                                $(".other-services-block a").each(function(){
                                    params = {'form_id' : 'response-add'};
                                    href = location.protocol + '//' + location.hostname + this.pathname;
                                    if (!$(this).attr('href').match('sso_redirect')) {
                                        $(this).attr("href", href + "?" + $.param(params));
                                    }
                                });
                                return false;
                            }
                        });
                        $(".widget-back a").click(function(){
                            $(".widget-adv-add-response").removeClass("wide");
                            $(".widget-back").hide();
                            $("#response-add").show();
                            $(".widget-adv-responses").show();
                            $(".login-inner").hide();
                            return false;
                        });
                        $('.widget-tab').click(function(){
                            $('.l-overlay').height($(document).height()).show();
                            $('.l-ur-body').show();
                        });
                        $('.b-ur-close').click(function(){
                            $('.l-ur-body').hide();
                            $('.l-overlay').hide();
                        });
                        $('.b-ur-tabs li').click(function(){
                            //reset search
                            $("#search-content").remove();
                            $(".b-ur-search-input form input.b-ur-text-input").css('color','#acacac').val(App.t('Enter response for us to find it'));
                            $(".b-ur-search-area .b-ur-btn1").show();
                            $(".search-link").hide();
                            
                            $('.b-ur-tabs li').removeClass('selected');
                            $('.b-ur-tabs li').find('.marker').hide();
                            $(this).addClass('selected');
                            $(this).find('.marker').show();
                            $('.b-ur-tab-content').hide();
                            $('.b-ur-tab-content').eq($(this).index()).show();
                            return false;
                        });
                        $('.b-ur-text-input').focusin(function(){
                            $(this).css('color','#000');
                            if ($(this).val() == App.t('Enter response for us to find it')) $(this).val('');
                        });
                        $('.b-ur-text-input').focusout(function(){
                            if ($(this).val() == '') {
                                $(this).css('color','#acacac').val(App.t('Enter response for us to find it'));
                            }
                        });
                        $(".b-ur-search-input form").submit(function(){
                            input = $(this).find("input.b-ur-text-input");
                            if (input.val() == '' || input.val() == App.t('Enter response for us to find it')) {
                                return false;
                            }
                            type = $(".b-ur-tabs .selected a").attr("id");
                            if (type != undefined) {
                                type = type.replace(/-responses/i, "");
                            } else {
                                type = 'all';
                            }
                            submit = $(this).find('input[type=submit]');
                            submit.addClass("preloader");
                            
                            url = App.baseUrl('/quick/search/' + encodeURIComponent(input.val()));
                            App.remote.get(url, {'widget' : '1', 'type' : type}, function(r) {
                                result = App.remote.parseResult(r);
                                submit.removeClass('preloader');
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                output = result.data.getOutput();
                                if (output) {
                                    content = $(".content");
                                    content.find(".b-ur-tab-content").hide();
                                    content.append(output);
                                    $(".b-ur-tabs li").removeClass("selected");
                                    $(".b-ur-tabs li a .marker").hide();
                                    
                                    $(".b-ur-search-area .b-ur-btn1").hide();
                                    $(".search-link").show();
                                    $(".search-link.floatRight").attr("href", App.baseUrl('/response/add/' + type + '/?text=' + result.data.getParam('text')));
                                } else {
                                    window.parent.location.href = App.baseUrl('/response/add/' + type + '/?text=' + result.data.getParam('text'));
                                }
                            });
                            return false;
                        });
                        $("#reset-search").click(function(){
                            $('.b-ur-tabs li').eq(0).click();
                            return false;
                        });
                    });
                }
            },
            activity : {
                index : function() {
                    $('.table-view .activity:odd').addClass('color-obj');
                }
            }
        }
    }
});

$(document).ready(function(){
    $(".subscribe-link.email").live("click", function(){
        link = $(this);
        if (App.getParam('isGuest')) {
            params = {'redirect' : link.attr("href")};
            App.openLoginPopup(params);
        } else {
            img = link.css("background-image");
            link.css("background-image", 'url(' + App.baseUrl('/public/assets/images/preloader.gif') + ')');
            App.remote.get(link.attr("href"), {format:'json'}, function(r) {
                result = App.remote.parseResult(r);
                link.css("background-image", img);
                if (result.data.isError()) {
                    App.notify.error(result.data.getMessage());
                    return false;
                }
                App.notify.success(result.data.getMessage());
                link.parent().append(result.data.getOutput());
                link.remove();
            });
        }
        return false;
    });

    $('#system-form-registration').on('submit', function (event) {
        var regAssign  = $('#assign'),
            dataToHash = $('#full_name').val() + $('#registration-email').val();
        regAssign.val(App.utils.md5(dataToHash));
    });
});
