<?php
namespace Useresponse\Sdk\Services;

use Useresponse\Sdk\Adapters\IAdapter;

/**
 * Class Users
 *
 * @package Useresponse\Sdk\Services
 */
class Users extends ServiceAbstract
{

    /**
     * Fetch users.
     *
     * @param array $data
     * @return mixed
     */
    public function getUsers(array $data = [])
    {
        $result = $this->adapter->request('users/search', IAdapter::TYPE_GET, $data);

        return $this->makeResponse($result);
    }

    /**
     * Fetch user by id.
     *
     * @param int $id
     * @param bool $includeStatistic
     * @return mixed
     * @throws \Exception
     */
    public function getUser($id, $includeStatistic = false)
    {
        if (!isset($id)) {
            throw new \Exception("User id is required!");
        }

        $result = $this->adapter->request('users/' . (int)$id, IAdapter::TYPE_GET, ['includeStatistics' => (int)$includeStatistic]);

        return $this->makeResponse($result);
    }

    /**
     * Add new user.
     *
     * @param array $data
     * @return mixed
     * @throws \Exception
     */
    public function addUser(array $data)
    {
        $result = $this->adapter->request('users', IAdapter::TYPE_POST, $data);

        return $this->makeResponse($result);
    }

    /**
     * Edit user by id.
     *
     * @param int $id
     * @param array $data
     * @return mixed
     * @throws \Exception
     */
    public function editUser($id, array $data)
    {
        if (!isset($id)) {
            throw new \Exception("User id is required!");
        }

        $result = $this->adapter->request('users/' . (int)$id, IAdapter::TYPE_POST, $data);

        return $this->makeResponse($result);
    }

    /**
     * Change password by user_id.
     *
     * @param int $id
     * @param string $password
     * @return mixed
     * @throws \Exception
     */
    public function changePassword($id, $password)
    {
        if (!isset($id)) {
            throw new \Exception("User id is required!");
        }

        $result = $this->adapter->request('users/' . (int)$id . '/change-password', IAdapter::TYPE_POST, ['password' => $password]);

        return $this->makeResponse($result);
    }

    /**
     * Delete user by id.
     *
     * @param int $id
     * @return mixed
     * @throws \Exception
     */
    public function deleteUser($id)
    {
        if (!isset($id)) {
            throw new \Exception("User id is required!");
        }

        $result = $this->adapter->request('users/' . (int)$id, IAdapter::TYPE_DELETE);

        return $this->makeResponse($result);
    }

    /**
     * Get activity by user id.
     *
     * @param int $userId
     * @return mixed
     * @throws \Exception
     */
    public function getActivity($userId)
    {
        if (!isset($userId)) {
            throw new \Exception("User id is required!");
        }

        $result = $this->adapter->request('users/' . (int)$userId . '/activity', IAdapter::TYPE_GET);

        return $this->makeResponse($result);
    }

    /**
     * List custom fields.
     *
     * @return mixed
     */
    public function listCustomFields()
    {
        $result = $this->adapter->request('users/custom-fields/list');

        return $this->makeResponse($result);
    }
}
