<?php
namespace Useresponse\Sdk\Services;

use Useresponse\Sdk\Adapters\IAdapter;

/**
 * Class Comments
 *
 * @package Useresponse\Sdk\Services
 */
class Comments extends ServiceAbstract
{

    /**
     * Add new comment to object.
     *
     * @param int $objectId
     * @param string $body
     * @param int $replyTo
     * @return mixed
     * @throws \Exception
     */
    public function addComment($objectId, $body, $replyTo = 0)
    {
        $result = $this->adapter->request('comments', IAdapter::TYPE_POST, [
            'content' => $body,
            'object_id' => $objectId,
            'reply_to' => (int)$replyTo
        ]);

        return $this->makeResponse($result);
    }

    /**
     * Toggle best comment.
     *
     * @param int $commentId
     * @return mixed
     * @throws \Exception
     */
    public function toggleBest($commentId)
    {
        if (!isset($commentId)) {
            throw new \Exception("Comment id is required!");
        }

        $result = $this->adapter->request('comments/' . (int)$commentId . '/best/toggle', IAdapter::TYPE_GET);

        return $this->makeResponse($result);
    }

    /**
     * Move comment to trash.
     *
     * @param int $commentId
     * @return mixed
     * @throws \Exception
     */
    public function moveToTrash($commentId)
    {
        if (!isset($commentId)) {
            throw new \Exception("Comment id is required!");
        }

        $result = $this->adapter->request('comments/' . (int)$commentId . '/trash', IAdapter::TYPE_GET);

        return $this->makeResponse($result);
    }

    /**
     * Recover comment.
     *
     * @param int $commentId
     * @return mixed
     * @throws \Exception
     */
    public function recover($commentId)
    {
        if (!isset($commentId)) {
            throw new \Exception("Comment id is required!");
        }

        $result = $this->adapter->request('comments/' . (int)$commentId . '/recovery', IAdapter::TYPE_GET);

        return $this->makeResponse($result);
    }

    /**
     * Toggle vote for comment.
     *
     * @param int $commentId
     * @return mixed
     * @throws \Exception
     */
    public function toggleVote($commentId)
    {
        if (!isset($commentId)) {
            throw new \Exception("Comment id is required!");
        }

        $result = $this->adapter->request('comments/' . (int)$commentId . '/votes/toggle', IAdapter::TYPE_GET);

        return $this->makeResponse($result);
    }

    /**
     * Get comments by object id.
     *
     * @param int $objectId
     * @param array $options
     * @return mixed
     * @throws \Exception
     */
    public function getByObject($objectId, array $options = [])
    {
        if (!isset($objectId)) {
            throw new \Exception("Object id is required!");
        }

        $result = $this->adapter->request('objects/' . (int)$objectId . '/comments', IAdapter::TYPE_GET, $options);

        return $this->makeResponse($result);
    }
}