<?php

namespace Useresponse\Sdk\Services;

use Useresponse\Sdk\Response;
use Useresponse\Sdk\Adapters\IAdapter;

/**
 * Class ServiceAbstract
 *
 * @package Useresponse\Sdk\Services
 */
abstract class ServiceAbstract
{

    /**
     * API adapter.
     *
     * @var IAdapter
     */
    protected $adapter;

    /**
     * Response format.
     *
     * @var string
     */
    protected $format ;

    /**
     * Service constructor.
     *
     * @param IAdapter $adapter
     * @param string $format
     */
    public function __construct(IAdapter $adapter, $format)
    {
        $this->adapter = $adapter;
        $this->format = $format;
    }

    /**
     * Get available methods.
     *
     * @return array
     */
    public function getAvailableMethods()
    {
        $reflectionMethods = (new \ReflectionClass($this))->getMethods();
        $methods = [];

        foreach ($reflectionMethods as $reflectionMethod) {
            $method = $reflectionMethod->getName();

            if (
                $reflectionMethod->isPublic() &&
                preg_match('/^[^_]/', $method) &&
                !in_array($method, ['getAvailableMethods', 'hasMethod'])
            ) {
                $methods[] = $method;
            }
        }

        return $methods;
    }

    /**
     * Has method.
     *
     * @param string $method
     * @return bool
     */
    public function hasMethod($method)
    {
        return method_exists($this, $method);
    }

    /**
     * Make response.
     *
     * @param \stdClass $result
     * @return mixed
     */
    protected function makeResponse(\stdClass $result)
    {
        return (new Response($result, $this->format))->fetch();
    }

}