<?php

namespace Useresponse\Sdk\Decoders;

/**
 * Class Json
 *
 * @package Useresponse\Sdk\Decoders
 */
class Json extends DecoderAbstract
{

    /**
     * Decoding error.
     *
     * @var string
     */
    protected $error;

    /**
     * Decode data.
     *
     * @return mixed
     */
    public function decode()
    {
        if (!function_exists('json_last_error_msg')) {
            require __DIR__ . '/../Functions/JsonLastErrorMsg.php';
        }

        $result = json_decode($this->data);
        $this->error = json_last_error_msg();

        if ($this->error === 'No error') {
            $this->error = null;
        }

        return $result;
    }

    /**
     * Get decode error.
     *
     * @return string
     */
    public function getError()
    {
        return $this->error;
    }

}