<?php

namespace Useresponse\Sdk\Adapters;

/**
 * Class Curl
 *
 * @package Useresponse\Sdk\Adapters
 */
class Curl extends AdapterAbstract
{

    /**
     * Make get request.
     *
     * @param string $uri
     * @param string $type
     * @param array $data
     * @return \stdClass
     * @throws \Exception
     */
    public function request($uri, $type = self::TYPE_GET, array $data = [])
    {
        $url = $this->source . '/' . ltrim($uri, '/') . '.' . $this->format;
        $options = array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER         => false,
            CURLOPT_FOLLOWLOCATION => false,
            CURLOPT_ENCODING       => 'UTF-8',
            CURLOPT_AUTOREFERER    => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false
        );

        if (null !== $this->key && !array_key_exists('apiKey', $data)) {
            $data['apiKey'] = $this->key;
        }

        $type = strtolower($type);

        switch ($type) {
            case self::TYPE_DELETE:
            case self::TYPE_GET:
                if (is_array($data) && count($data)) {
                    $glue = strpos($url, '?') === false ? '?' : '&';
                    $url .= $glue . http_build_query($data);
                }

                break;
            case self::TYPE_POST:
                $options[CURLOPT_POST] = true;
                $options[CURLOPT_POSTFIELDS] = $data;
                break;
            case self::TYPE_PUT:
                $options[CURLOPT_POSTFIELDS] = json_encode($data);
                break;
        }

        if (in_array($type, [self::TYPE_PUT, self::TYPE_DELETE])) {
            $options[CURLOPT_CUSTOMREQUEST] = strtoupper($type);
        }

        $options[CURLOPT_URL] = $url;
        $ch = curl_init($url);
        curl_setopt_array($ch, $options);
        $result = [
            'content'  => curl_exec($ch),
            'httpCode' => curl_getinfo($ch)['http_code'],
            'errno'    => curl_errno($ch),
            'error'    => curl_error($ch)
        ];
        curl_close($ch);

        return (object)$result;
    }
}