<?php

namespace Useresponse\Sdk\Adapters;

/**
 * Class AdapterAbstract
 *
 * @package Useresponse\Sdk\Adapters
 */
abstract class AdapterAbstract implements IAdapter
{

    /**
     * API base url.
     *
     * @var string
     */
    protected $source;

    /**
     * API key.
     *
     * @var string
     */
    protected $key;

    /**
     * Response format.
     *
     * @var string
     */
    protected $format;

    /**
     * Adapter constructor.
     *
     * @param array $config
     * @throws \Exception
     */
    public function __construct(array $config)
    {
        if (empty($config['apiSource'])) {
            throw new \Exception("Source is required!");
        }

        $this->source = rtrim($config['apiSource'], '/');
        $this->key = array_key_exists('apiKey', $config) ? $config['apiKey'] : null;
        $this->format = $config['format'];
    }
}