<?php

namespace Useresponse\Sdk\Decoders;

/**
 * Class DecoderAbstract
 *
 * @package Useresponse\Sdk\Decoders
 */
abstract class DecoderAbstract implements IDecoder
{

    /**
     * Data.
     *
     * @var string
     */
    protected $data;

    /**
     * Json decoder constructor.
     *
     * @param string $data
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Get raw data.
     *
     * @return string
     */
    public function getRaw()
    {
        return $this->data;
    }

}