<?php

namespace Useresponse\Sdk\Adapters;

/**
 * Interface IAdapter
 *
 * @package Useresponse\Sdk\Adapters
 */
interface IAdapter
{

    const TYPE_GET    = 'get';
    const TYPE_POST   = 'post';
    const TYPE_PUT    = 'put';
    const TYPE_DELETE = 'delete';

    /**
     * Make get request.
     *
     * @param string $uri
     * @param string $type
     * @param array $data
     * @return \stdClass
     */
    public function request($uri, $type = self::TYPE_GET, array $data = []);
}