<?php
namespace Useresponse\Sdk\Services;

use Useresponse\Sdk\Adapters\IAdapter;

/**
 * Class Categories
 *
 * @package Useresponse\Sdk\Services
 */
class Categories extends ServiceAbstract
{

    /**
     * Fetch categories.
     *
     * @param array $data
     * @return mixed
     */
    public function getCategories(array $data = [])
    {
        $result = $this->adapter->request('categories', IAdapter::TYPE_GET, $data);

        return $this->makeResponse($result);
    }

    /**
     * Fetch category by id.
     *
     * @param int $id
     * @return mixed
     * @throws \Exception
     */
    public function getCategory($id)
    {
        if (!isset($id)) {
            throw new \Exception("Category id is required!");
        }

        $result = $this->adapter->request('categories/' . (int)$id, IAdapter::TYPE_GET);

        return $this->makeResponse($result);
    }

}