<?php
namespace Useresponse\Sdk\Services;

use Useresponse\Sdk\Adapters\IAdapter;

/**
 * Class Licenses
 *
 * @package Useresponse\Sdk\Services
 */
class Licenses extends ServiceAbstract
{

    /**
     * Fetch categories.
     *
     * @param string $domain
     * @return mixed
     */
    public function getAddOns($domain)
    {
        $result = $this->adapter->request('license/'.$domain.'/addons', IAdapter::TYPE_GET);

        return $this->makeResponse($result);
    }

    public function calculateAgents(array $data)
    {
        $result = $this->adapter->request('license/calculate', IAdapter::TYPE_POST, $data);

        return $this->makeResponse($result);
    }

    public function calculateAddon($addon_id, array $data)
    {
        $result = $this->adapter->request('addon/'.$addon_id.'/calculate', IAdapter::TYPE_POST, $data);

        return $this->makeResponse($result);
    }

    /**
     * Send account email.
     *
     * @param string $template
     * @param array $params
     * @return mixed
     */
    public function accountEmail($template, array $params)
    {
        $result = $this->adapter->request('account/email', IAdapter::TYPE_POST, [
            'template' => $template,
            'params'   => serialize($params)
        ]);

        return $this->makeResponse($result);
    }

    /**
     * Trigger cloud.
     *
     * @param int $licenseId
     * @return mixed
     */
    public function triggerCloud($licenseId)
    {
        $result = $this->adapter->request('license/'.(int)$licenseId.'/cloud/trigger', IAdapter::TYPE_GET);

        return $this->makeResponse($result);
    }
}