<?php
/**************************************************************
 * Copyright USWebStyle Inc., 2011-2012. All Rights Reserved.
 **************************************************************
 * NOTICE:  This source code is the property of USWebStyle, Inc.
 * In no case shall you rent, lease, lend, redistribute
 * any of below source code to a 3rd party individual or entity.
 *
 * @category   Loginplus
 * @package    Loginplus_Controller
 * @copyright  USWebStyle Inc., 2011-2012 (http://www.uswebstyle.com)
 * @license    http:/www.useresponse.com/licensing (Commercial)
 */

/**
 * SSO OneLogin controller
 *
 * @uses       System_Controller_Abstract_Auth
 * @category   Loginplus
 * @package    Loginplus_Controller
 */
class Loginplus_IntegrationController extends System_Controller_Abstract_Auth
{
    /**
     * Initialize object.
     * Called from {@link __construct()} as final step of object instantiation.
     *
     * @throws Singular_Acl_Exception
     */
    public function init()
    {
        parent::init();
        $authMethod = $this->settings->loginplus->default->sso_active_method->value;
        if ('ldap' == $authMethod) {
            $this->_helper->redirector->gotoRouteAndExit(array('method' => 'ldap', 'redirect' => 'reset'), 'login');
        }
        if ($authMethod != 'integration') {
            throw new Singular_Acl_Exception(
                $this->view->t('Access denied')
            );
        }
    }
  

    /**
     * Generates cookie to be handled by UseResponse auth to authenticate/register user
     * based on SSO integration user data. Returns javascript code to perform redirect,
     * if requested by 'redirect' parameter.
     *
     * @return void
     */
    public function javascriptAction()
    {
        $secret = Loginplus_Model_Integration::getSecret(
            Singular_Core::_('settings')->getSetting('sso_onelogin_domain')
        );

        $data = $this->getRequest()->getParams();

        foreach ($data as $key=>$value) {
            if (!in_array($key, array('module', 'controller', 'action', 'hash')))
                $data[$key] = Loginplus_Model_Integration::decrypt($value, $secret);
        }

        if ($data['source'] != Singular_Core::_('settings')->getSetting('sso_onelogin_domain')) {
            die($this->_helper->t('Domain name not allowed for Login Integrations'));
            return;
        }

        $data['email'] = Loginplus_Model_Integration::encrypt($data['email'], $secret);

        unset($data['secret']);
        unset($data['module']);
        unset($data['controller']);
        unset($data['action']);

        header('Content-Type: text/javascript;charset=utf-8', true);
        setcookie("sso_user", Zend_Json::encode($data), time()+(14*24*60*60), "/");
        if ($data['redirect'] == 1) echo "location.href='{$this->view->baseUrl()}';";

        exit;
    }

    public function loginurlAction()
    {
        $loginUrl = Singular_Core::_('settings')->getSetting('sso_onelogin_loginurl');
        header("Location: {$loginUrl}");
        exit;
    }

}
