<?php
class UseresponseSso
{
    protected static $_jsTemplate = '<script type="text/javascript" src="#domain#/sso/#source#/#fullname#/#email#/#user_id#/#hash#/#redirect##properties#"></script>';
    protected static $_directUrl = '#domain#/sso/#source#/#fullname#/#email#/#user_id#/#hash#/direct-sso#properties#';
    protected static $_errors = [];
    protected static $_options = [
        'source'   => null,
        'domain'   => null,
        'secret'   => null,
        'fullname' => null,
        'email'    => null,
        'user_id'  => null,
        'invalid'  => false,
        'redirect' => 0,
    ];
    protected static $properties = [];

    protected static function encrypt($string, $key)
    {
        $key = sha1($key);
        $strLen = strlen($string);
        $keyLen = strlen($key);
        $j=0; $hash='';
        for ($i = 0; $i < $strLen; $i++) {
            $ordStr = ord(substr($string,$i,1));
            if ($j == $keyLen) { $j = 0; }
            $ordKey = ord(substr($key,$j,1));
            $j++;
            $hash .= strrev(base_convert(dechex($ordStr + $ordKey),16,36));
        }
        return $hash;
    }
    
    protected static function _generateHash($data, $key)
    {
        if (!isset($data['fullname']) || !isset($data['user_id']) || !isset($data['email']) || !isset($data['source'])
        ) {
            return false;
        }
        $key = sha1(md5(strrev($key)));
        $hashable = array(
            $data['fullname'],
            $data['user_id'],
            $data['email'],
            $data['source']
        );
        $hashable = implode($key, $hashable);

        return sha1(strrev($hashable));
    }


    protected static function _validateOptions()
    {
        if (is_null(self::$_options)) {
            self::$_errors[] = 'Method "setup" accepts 1 parameter, none provided';
        }

        // Domain Name validation
        if (!isset(self::$_options['domain']) OR empty(self::$_options['domain'])) {
            self::$_errors[] = 'Domain name not found in configuration array';
        }

        // Secret Key validation
        if (!isset(self::$_options['secret']) OR empty(self::$_options['secret'])) {
            self::$_errors[] = 'Secret key not found in configuration array';
        }

        // User Name validation
        if (!isset(self::$_options['fullname']) OR empty(self::$_options['fullname'])) {
            self::$_errors[] = 'User name not found in configuration array';
        }

        // User Email validation
        if (!isset(self::$_options['email']) OR empty(self::$_options['email'])) {
            self::$_errors[] = 'User email not found in configuration array';
        }

        // User Id validation
        if (!isset(self::$_options['user_id']) OR empty(self::$_options['user_id'])) {
            self::$_errors[] = 'User id not found in configuration array';
        }

        if (empty(self::$_errors)) {
            self::$_options['invalid'] = false;
        } else {
            self::$_options['invalid'] = true;
        }
    }

    protected static function _processProperties($options = null)
    {
        self::$properties = [];

        if (is_array($options)) {
            foreach ($options as $option => $value) {
                if (preg_match('/^property_\d+$/', $option)) {
                    self::$properties[$option] = $value;
                    unset($options[$option]);
                }
            }
        }

        return $options;
    }

    public static function getParameters($parameters = null)
    {
        if (is_null($parameters)) $parameters = $_GET;

        if (isset($parameters['sso_redirect'])) {
            setcookie('sso_redirect', 1);
            $_SESSION['sso_redirect'] = 1;
        } elseif (!isset($parameters['sso_redirect']) && (isset($_COOKIE['sso_redirect']) || (isset($_SESSION['sso_redirect'])))) {
            if (isset($_SESSION['sso_redirect'])) self::$_options['redirect'] = $_SESSION['sso_redirect'];
            else self::$_options['redirect'] = $_COOKIE['sso_redirect'];
        }
    }

    public static function setup($options = null)
    {
        $options = self::_processProperties($options);

        self::$_options = array_merge(self::$_options, $options);
        self::$_options['source'] = $_SERVER['HTTP_HOST'];
        self::_validateOptions();
    }

    public static function script($direct = false)
    {
        if (self::$_options['invalid']) return;

        $output = $direct ? self::$_directUrl : self::$_jsTemplate;

        foreach (self::$_options as $key => $value) {
            if ($key != 'secret' && $key != 'domain') $value = self::encrypt($value, self::$_options['secret']);
            $output = str_replace("#{$key}#", $value, $output);
        }
        
        $hash = self::_generateHash(self::$_options, self::$_options['secret']);
        $output = str_replace("#hash#", $hash, $output);

        if (count(self::$properties) > 0) {
            $properties = '?' . http_build_query([
                'properties' => array_map(
                    function ($property) {
                        return self::encrypt($property, self::$_options['secret']);
                    },
                    self::$properties
                )
            ]);
        } else {
            $properties = '';
        }

        $output = str_replace("#properties#", $properties, $output);

        if ($direct) {
            setcookie('sso_redirect', 0, -1);
            $_SESSION['sso_redirect'] = 0;
            header('Location: ' . $output);
            exit;
        }
        
        ob_start();            
        setcookie('sso_redirect', 0, -1);
        $_SESSION['sso_redirect'] = 0;
        echo $output;
		ob_end_flush();
    }

}