<?php

if ($curVersion === "1.1.0") {
    if (null !== Singular_Core::_("settings")->getSetting('api_limit_rows')) {
        return true;
    }

    Singular_Core::_("settings")->addSettings(array(
        'key'         => 'api_limit_rows',
        'value'       => '1000',
        'type'        => 'number',
        'title'       => 'Limit',
        'description' => 'Limit',
        'module'      => 'system',
        'section'     => 'api'
    ));

    Singular_Core::_("settings")->addSettings(array(
        'key'         => 'api_is_enabled',
        'value'       => '1',
        'type'        => 'yes_no',
        'title'       => 'Enabled',
        'description' => 'Enabled',
        'module'      => 'system',
        'section'     => 'api'
    ));
    
    Singular_Core::_("settings")->addSettings(array(
        'key'         => 'anonymous_responses',
        'value'       => '0',
        'type'        => 'yes_no',
        'title'       => 'Anonymous Responses',
        'description' => 'Allow users to add responses anonymously without authentication.',
        'module'      => 'system',
        'section'     => 'general'
    ));
    
    Singular_Core::_("settings")->addSettings(array(
        'key'         => 'anonymous_captcha',
        'value'       => '0',
        'type'        => 'checkbox',
        'title'       => 'Use Captcha',
        'description' => '',
        'module'      => 'system',
        'section'     => 'general'
    ));
    
    Singular_Core::_("settings")->addSettings(array(
        'key'         => 'widget_design',
        'value'       => 'simple',
        'type'        => 'radio',
        'title'       => 'Widget Design',
        'description' => '',
        'module'      => 'system',
        'section'     => 'widget'
    ));
    
    Singular_Core::_("settings")->addSettings(array(
        'key'         => 'mobile_interface',
        'value'       => '0',
        'type'        => 'yes_no',
        'title'       => 'Use Mobile Interface',
        'description' => 'Advise optional interface to choose if using community from mobile',
        'module'      => 'system',
        'section'     => 'interface'
    ));

    $adapter->query("ALTER TABLE `{$tablePrefix}responses` CHANGE `tags` `tags` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL");
    $adapter->query("ALTER TABLE `{$tablePrefix}users` ADD `api_key` CHAR(32) NULL DEFAULT NULL");
    $adapter->query("ALTER TABLE `{$tablePrefix}users` CHANGE `photo` `photo` VARCHAR( 255 ) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL");
    $adapter->query("UPDATE `{$tablePrefix}settings` SET `type` = 'select' WHERE `{$tablePrefix}settings`.`key` ='widget_default_tab'");
    
    if (isset($installedModules['private'])) {
        $sql = "ALTER TABLE `{$tablePrefix}response_comments` DROP `is_private`";
        $adapter->query($sql);
    }
    
    if (isset($installedModules['merger'])) {
        $sql = "ALTER TABLE `{$tablePrefix}merger` ADD FULLTEXT (`title` , `description`)";
        $adapter->query($sql);
        $sql = "UPDATE `{$tablePrefix}email_templates` SET `variables` = '" . serialize(array('community_name','response_name','response_type','response_url','response_body','login_url','profile_url','main_response_type','main_response_url','main_response_name')) . "' WHERE slug='merged_responses'";
        $adapter->query($sql);
    }
    
    $sql = "DELETE FROM `{$tablePrefix}modules` WHERE `name` = 'system'";
    $adapter->query($sql);
}

return true;