App.module.extend({
    system: {
        controllers: {
            admin : {
                index : function() {
                    App.onReady(function(){
                        $(".sortByDate").change(function(){
                            location.href = App.baseUrl("/activity?date=" + $(this).val());
                        });
                    });
                }
            },
            adminLanguages : {
                _init : function() {
                    App.onReady(function() {
                        $(".translation-table .button-type3").click(function(){
                            obj = $(this).parents(".obj");
                            obj.find("input,textarea").val(obj.find("td .div-td").html().trim());
                        });
                        /* Focus translation elements */
                        $('.formObject').focusin(function(){
                            $('.translation-table tr').removeClass('active');
                            $(this).parent().parent().addClass('active');
                        });
                    });
                },
                index : function() {
                    App.onReady(function() {
                        $("input[type=file]").live("change", function(){
                            filename = this.value.replace(/^.*[\/\\]/g, "");
                            $(this).parent().find("input[type=text]").val(filename);
                        });
                        $("#language-add").click(function(){
                            block = $(".new-language-block.new");
                            if (block.is(":visible")) {
                                $(".new-language-block.new").fadeOut();
                            } else {
                                $(".new-language-block").fadeOut();
                                $(".new-language-block.new").fadeIn();
                            }
                            return false;
                        });
                        $(".new-language-block form").live("submit", function() {
                            form = $(this);
                            form.find(".textInput").removeClass("error");
                            nameInput = form.find("input[name=name]");
                            if (nameInput.val() == "") {
                                App.notify.error(App.t("Language name is required!"));
                                nameInput.parent().addClass("error");
                                return false;
                            }
                            code = form.find("input[name=code]");
                            if (code.val() == "") {
                                App.notify.error(App.t("Language code is required!"));
                                code.parent().addClass("error");
                                return false;
                            }
                        });
                        $("#switch_dict .iedit").live("click", function(){
                            link = $(this);
                            background = link.css("background-image");
                            link.css("background-image", "url(" + App.baseUrl("/public/assets/images/preloader.gif") + ")");
                            App.remote.get(link.attr("href"), {format:'json'}, function(r) {
                                $(".new-language-block").hide();
                                result = App.remote.parseResult(r);
                                link.css("background-image", background);
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                $(".new-language-block." + result.data.getParam('code')).remove();
                                $(".mainArea-type2.floatRight").prepend(result.data.getOutput());
                                $(".new-language-block." + result.data.getParam('code')).fadeIn();
                            });
                            return false;
                        });
                        $(".idelete").live("click", function(){
                            lang = $(this).parent().find("label span").text();
                            if (confirm(App.t("Are your sure you want to delete :lang", {'lang':lang}))) {
                                link = $(this);
                                background = link.css("background-image");
                                link.css("background-image", "url(" + App.baseUrl("/public/assets/images/preloader.gif") + ")");
                                App.remote.get(link.attr("href"), {format:'json'}, function(r) {
                                    result = App.remote.parseResult(r);
                                    if (result.data.isError()) {
                                        App.notify.error(result.data.getMessage());
                                        return false;
                                    }
                                    App.notify.success(result.data.getMessage());
                                    link.parent().remove();
                                    code = link.parent().find("input").val();
                                    $("#dict-" + code).remove();
                                    $('.color-obj').removeClass("color-obj");
                                    $('.table-view div.obj:odd').addClass("color-obj");
                                });
                            }
                            return false;
                        });
                        /* Switch dictionaries */
                        $('.lang div label').click(function(){
                                $('.lang div').removeClass('lang-active');
                                $(this).parent('div').addClass('lang-active');
                                $('.dictionary-group').hide();
                                $('.dictionary-group').eq($(this).parent().index()).show();
                            }
                        );
                    });
                }
            },
            adminRoles : {
                index : function() {
                    App.onReady(function(){
                        $("#add-new-role").click(function(){
                            $(".current-roles tr").removeClass("error");
                            block = $(".new-role-block.new");
                            if (block.is(":visible")) {
                                $(".new-role-block.new").fadeOut();
                            } else {
                                $(".new-role-block").fadeOut();
                                $(".new-role-block.new").fadeIn();
                            }
                            return false;
                        });
                        $(".iedit").live("click", function(){
                            $(".current-roles tr").removeClass("error");
                            link = $(this);
                            background = link.css("background-image");
                            link.css("background-image", 'url(' + App.baseUrl('/public/assets/images/preloader.gif') + ')');
                            App.remote.get(link.attr("href"), {format:'json'}, function(r) {
                                $(".new-role-block").hide();
                                result = App.remote.parseResult(r);
                                link.css("background-image", background);
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                $(".new-role-block." + result.data.getParam('roleSlug')).remove();
                                $(".mainArea-type2.floatRight").prepend(result.data.getOutput());
                                $('.table-col1 .table-col-line:odd').addClass('color-obj');
                                $('.table-col2 .table-col-line:odd').addClass('color-obj');
                                $(".new-role-block." + result.data.getParam('roleSlug')).fadeIn();
                            });
                            return false;
                        });
                        $(".idelete").live("click", function(){
                            role = $(this).parent().parent().find("td").eq(0).text();
                            if (confirm(App.t("Are your sure you want to delete role - " + role))) {
                                $(".current-roles tr").removeClass("error");
                                link = $(this);
                                background = link.css("background-image");
                                link.css("background-image", "url(" + App.baseUrl("/public/assets/images/preloader.gif") + ")");
                                App.remote.get(link.attr("href"), {format:'json'}, function(r){
                                    result = App.remote.parseResult(r);
                                    if (result.data.isError()) {
                                        App.notify.error(result.data.getMessage());
                                        return false;
                                    }
                                    App.notify.success(result.data.getMessage());
                                    link.parent().parent().remove();
                                    $('.color-obj').removeClass("color-obj");
                                    $('.current-roles tr:odd').addClass("color-obj");
                                });
                            }
                            return false;
                        });
                        $(".new-role-block form").live("submit", function(){
                            $(".current-roles tr").removeClass("error");
                            form = $(this);
                            roleInput = form.find(".textInput #name");
                            if (roleInput.val() == "") {
                                App.notify.error(App.t("Role name is required!"));
                                roleInput.parent().addClass("error");
                                return false;
                            }
                            error = false;
                            if (form.parent().hasClass("new")) {
                                $(".current-roles tr").each(function(){
                                    roleName = $(this).find("td").eq(0).text().trim()
                                    if (roleName == roleInput.val()) {
                                        $(this).addClass("error");
                                        roleInput.parent().addClass("error");
                                        App.notify.error("Such Role already exists!");
                                        error = true;
                                    }
                                });
                            }
                            if (error) {
                                return false;
                            }
                            data = {
                                format: 'json',
                                name: roleInput.val(),
                                resource: {}
                            };
                            form.find(".table-col-line input:checked").each(function(){
                                data.resource[$(this).val()] = $(this).val();
                            });
                            form.find(".preloader").show();
                            App.remote.post(form.attr("action"), data, function(r){
                                result = App.remote.parseResult(r);
                                $(".current-roles tr").removeClass("error");
                                $(".preloader").hide();
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                App.notify.success(result.data.getMessage());
                                form.parent().fadeOut();
                                if (result.data.getAction() == "add") {
                                    form.find("#reset").click();
                                    $(".current-roles tbody").append(result.data.getOutput());
                                    $(".color-obj").removeClass("color-obj");
                                    $(".current-roles tr:odd").addClass("color-obj");
                                } else {
                                    role = result.data.getParam("roleSlug");
                                    $("tr#" + role + " td").eq(0).html(roleInput.val());
                                }
                            });
                            return false;
                        });
                    });
                }
            },
            adminInterface: {
                widget: function() {
                    App.onReady(function(){
                         $('input[name=widget_side]').click(function(){
                             if($(this).val() == 'left') {
                                 $('.widget-demo').removeClass('w-right').addClass('w-left');
                             } else {
                                $('.widget-demo').removeClass('w-left').addClass('w-right');
                             }
                         });
                         $("#widget_background_color").change(function(){
                             $('.widget-demo').css('background-color', '#'+this.color);
                         });
                         $("#widget_border_color").change(function(){
                             $('.widget-demo').css('border-color', '#'+this.color);
                         });
                         $('#widget_round_corners').click(function(){
                            $('.widget-demo').toggleClass('w-round');
                         });
                         $('#widget_drop_shadow').click(function(){
                            $('.widget-demo').toggleClass('w-shadow');
                         });
                         $("input[name=widget_design]").click(function(){
                             if ($(this).val() == 'advanced') {
                                 $(".monitor").addClass('advanced');
                             } else {
                                 $(".monitor").removeClass('advanced');
                             }
                         });
                         // Initialization widget
                         $('.widget-demo').css('background-color', '#' + $('#widget_background_color').val());
                         $('.widget-demo').css('border-color', '#' + $('#widget_border_color').val());
                         $('input[name=widget_side]:checked').click();
                         if ($('#widget_round_corners').attr('checked')) $('.widget-demo').addClass('w-round');
                         if ($('#widget_drop_shadow').attr('checked')) $('.widget-demo').addClass('w-shadow');

                         $("#submit").click(function(){
                            $("#system-form-widget").submit();
                         });
                         $("#get-code").click(function(){
                            onClick = '';
                            code = '<script type="text/javascript">';
                            if ($("input[name=widget_design]:checked").val() == 'advanced') {
                                code += 'var URWidgetListener = function (event) {';
                                code += '  if (event.data.indexOf("redirect") == 0) {';
                                code += '    found = event.data.match(/redirect:url\\(([^\\)]*)\\)/);';
                                code += '    if (found.length == 2) {';
                                code += '      location.href = found[1];';
                                code += '    }';
                                code += '  }';
                                code += '};';
                                code += 'if (window.addEventListener) {';
                                code += '  window.addEventListener("message", URWidgetListener, false);';
                                code += '} else {';
                                code += '  window.attachEvent("onmessage", URWidgetListener);';
                                code += '}';
                            }
                            code += ' var head  = document.getElementsByTagName("head")[0];var link  = document.createElement("link");link.rel  = "stylesheet";link.type = "text/css";link.href = "' + App.baseUrl('/public/themes/' + App.getParam('defaultTheme', 'default') + '/assets/css/widget.css') + '";link.media = "all";head.appendChild(link);</script>';
                            if ($("input[name=widget_open]:checked").val() == "widget") {
                                href = App.baseUrl('/widget');
                                code += '<script type="text/javascript">widget = {url:\'' + App.baseUrl() + '\'}</script>';
                                code += '<script src="' + App.baseUrl('/public/assets/modules/system/js/widget.js') + '" type="text/javascript"></script>\n';
                                width = 600;
                                height = 400;
                                if ($("input[name=widget_design]:checked").val() == 'advanced') {
                                    width = 765;
                                    height = 405;
                                }
                                onClick = 'javascript:popup(\'widget\', \'' + href + '\', ' + width + ', ' + height + ');';
                                target = "";
                            } else {
                                onClick = App.baseUrl();
                                target = "target='_blank'";
                            }
                            classes = "widget-tab";
                            if ($("input[name=widget_side]:checked").val() == "left") {
                                classes += " widget-tab-left";
                            }else {
                                classes += " widget-tab-right";
                            }
                            if ($("#widget_round_corners").attr("checked")) {
                                classes += " w-round";
                            }
                            if ($("#widget_drop_shadow").attr("checked")) {
                                classes += " w-shadow";
                            }
                            style = "margin-top:-" + App.getParam('widgetMarginTop') + "px;";
                            if ($("#widget_background_color").val() != "") {
                                style += "background-color:#" + $("#widget_background_color").val() + ";";
                            }
                            if ($("#widget_border_color").val() != "") {
                                style += "border-color:#" + $("#widget_border_color").val() + ";";
                            }
                            code += '<a class="' + classes + '" style="' + style + '" title="' + $("#widget_text").val() + '" href="' + onClick + '" ' + target + ' >\n';
                            code += '  <img width="15" alt="" src="' + App.getParam('widgetTextUrl') + '" />\n';
                            code += '</a>';
                            $(".code-for-widget textarea").val(code);
                            $(".code-for-widget").fadeIn();
                         });
                    });
                }
            },
            adminSettings : {
                general : function() {
                    App.onReady(function(){
                        $("input[type=file]").change(function(){
                            filename = this.value.replace(/^.*[\/\\]/g, "");
                            $(this).parent().find("input[type=text]").val(filename);
                        });
                        $("input[name=anonymous_responses]").live('click', function(){
                            if ($(this).val() == "1") {
                                $("label[for=anonymous_captcha]").show();
                            } else {
                                $("label[for=anonymous_captcha]").hide();
                            }
                        });
                        $("input[name=anonymous_responses]:checked").click();
                    });
                }
            },
            adminResponses : {
                index : function() {
                    App.onReady(function(){
                        $("input[name=use_negative_votes]").click(function(){
                            if ($(this).val() == "1") {
                                $(".dropDown-div").show();
                            } else {
                                $(".dropDown-div").hide();
                            }
                        });
                    });
                }
            },
            adminTrash : {
                index : function() {
                    App.onReady(function(){
                        $("#clear-trash").click(function(){
                           if (!confirm(App.t("Are you sure? You can't UNDO this operation!"))) {
                               return false;
                           }
                        });
                        $("#admin-trash-form").submit(function(){
                            if ($("select[name=trash-action]").val() == 'delete') {
                                if (!confirm(App.t("Are you sure? You can't UNDO this operation!"))) {
                                    return false;
                                }
                            }
                        });
                        $(".recovery, .delete").live("click", function(){
                            if ($(this).hasClass("delete")) {
                                if (!confirm(App.t("Are you sure? You can't UNDO this operation!"))) {
                                    return false;
                                }
                            }
                            object = $(this).parents(".object");
                            object.find(".checkResponse").hide();
                            object.find(".preloader").show();
                            App.remote.get($(this).attr("href"), {}, function(r){
                                result = App.remote.parseResult(r);
                                object.find(".preloader").hide();
                                if (result.data.isError()) {
                                    App.notify.error(result.data.getMessage());
                                    return false;
                                }
                                App.notify.success(result.data.getMessage());
                                object.fadeOut('slow', function(){
                                    if ($(".objects .object:visible").length == 0) {
                                        $(".objects").html("<p class='result-not-found'>" + App.t("Trash is empty") + "</p>");
                                        $(".filter-area-add").fadeOut();
                                    }
                                });
                            });
                            return false;
                        });
                    });
                }
            },
            adminModules : {
                index : function() {
                    App.onReady(function(){
                        $("#ftp-access").click(function(){
                            if ($(".dropDown-div.ftp-access").is(":visible")) {
                                $(".dropDown-div.ftp-access").fadeOut();                                
                            } else {
                                $(".dropDown-div.ftp-access").fadeIn();
                            }
                            return false;
                        });
                        $(".udgrade").click(function() {
                            $("#upgrade-title, #upgrade-description").remove();
                            $(".dropDown-div.upgrade-form, .dropDown-div.upgrade-process").remove();
                            if (!$(".dropDown-div.upgrade-form").is(":visible")) {
                                button = $(this);
                                button.hide();
                                preloader = $(this).parents(".object").find(".preloader");
                                preloader.show();
                                params = {
                                    url: App.baseUrl('/admin/upgrade'),
                                    data: {step: 'prepare'},
                                    success: function(response) {
                                        output = response.data.getOutput();
                                        $(".mainArea-type2 .modules-area").prepend(output);
                                    },
                                    complete: function(response){
                                        preloader.hide();
                                        button.show();
                                    },
                                    error: function(response){
                                        App.notify.error(response.data.getMessage());
                                    }
                                };
                                App.remote.post(params);
                            }
                            return false;
                        });

                        step = function (objects) {
                            obj = $(objects.shift());
                            obj.find('i').addClass('preloader');
                            params = {
                                url:App.baseUrl('/admin/upgrade'),
                                data:{step:obj.attr('id')},
                                success:function (response) {
                                    if (objects.length > 0) {
                                        step(objects);
                                    } else {
                                        App.notify.success(response.data.getMessage());
                                        setTimeout(function () {
                                            location.reload();
                                        }, 5000);
                                    }
                                },
                                complete:function (response) {
                                    if (!jQuery.isPlainObject(response.data)) {
                                        obj.find('i').removeClass('preloader').addClass('delete');
                                        ;
                                        $(objects).each(function () {
                                            $(this).find("i").addClass('delete');
                                        });
                                        $("#rollback").show();
                                        return;
                                    }
                                    obj.find('i').removeClass('preloader')
                                            .addClass(response.data.getParam('icon'));
                                },
                                error:function (response) {
                                    App.notify.error(response.data.getMessage());
                                    $(objects).each(function () {
                                        $(this).find("i").addClass('delete');
                                    });
                                    $("#rollback").show();
                                }
                            };
                            App.remote.post(params);
                        };

                        $("#start-upgrade").live("click", function () {
                            var objects = [];
                            form = $(this).parents("form");
                            data = {};
                            data['settings'] = App.getFormParams(form);
                            data['step'] = 'start';
                            params = {
                                url:App.baseUrl('/admin/upgrade'),
                                data:data,
                                success:function (response) {
                                    if (!jQuery.isPlainObject(response.data)) {
                                        return;
                                    }
                                    $(".upgrade-form").remove();
                                    output = response.data.getOutput();
                                    descr = response.data.getParam('description');
                                    $("#upgrade-description").html(descr);
                                    $("#upgrade-description").after(output);
                                    $('.upgrade-process .table-col-line').each(function () {
                                        if ($(this).attr("id") != "rollback") {
                                            objects.push($(this));
                                        }
                                    });
                                    step(objects);
                                }
                            };
                            App.remote.post(params);
                            return false;
                        });
                        
                        $("#testconnect").click(function(){
                            form = $("#system-form-ftpaccess");
                            form.find(".preloader").show();
                            params = {
                                url: App.baseUrl('/admin/modules/ftp-test-connect'),
                                data: App.getFormParams(form),
                                success: function(response) {
                                    App.notify.success(response.data.getMessage());
                                },
                                complete: function(){
                                    form.find(".preloader").hide(); 
                                },
                                error: function(response) {
                                    App.notify.error(response.data.getMessage());
                                }
                            };
                            App.remote.post(params);
                        });
                        $(".activeCheckbox input").click(function(){
                            var input = $(this);
                            input.hide();
                            input.parent().css("margin-top", "0px");
                            input.parent().append('<i class="preloader" style="display:block;margin:0"></i>');
                            if (input.is(":checked")) {
                                value = 1;
                                input.attr("title", App.t('Disactivate Module'));
                            } else {
                                value = 0;
                                input.attr("title", App.t('Activate Module'));
                            }
                            params = {
                                url: App.baseUrl('/admin/modules/activation'),
                                data: {'name': input.attr('name'), 'value': value},
                                success: function(response) {
                                    input.show();
                                    input.parent().css("margin-top", "3px");
                                    input.parent().find(".preloader").remove();
                                    App.notify.success(response.data.getMessage());
                                },
                                error: function(response) {
                                    App.notify.error(response.data.getMessage());
                                }
                            };
                            App.remote.get(params);
                        });
                        $("a.delete-module").click(function(){
                            module = $(this).parent().find(".content-object-title a").text().trim();
                            if (!confirm(App.t('You want to uninstall ":moduleName" module. There is no UNDO action. Continue?', {moduleName: module}))) {
                                return false;
                            }
                        });
                    });
                }
            }
        }
    }
});

$(document).ready(function(){
    /* Help Block On\Off */
    $('.info-block-head').click(function(){
        if ($(this).next().css('display') == 'none') {
            document.cookie="help=block; path=/;";
            $(this).next().slideDown('fast');
            $(this).children('i').removeClass('over');
        } else {
            document.cookie="help=none; path=/;";
            $(this).next().slideUp('fast');
            $(this).children('i').addClass('over');
        }
        return false;
    });
    $('.checkAllREsponses input').live("click", function(){
        if ($(this).is(':checked'))
        {
            $('.objects .object').addClass('active');
            $('.checkResponse input').attr('checked','checked');
        } else {
            $('.objects .object').removeClass('active');
            $('.checkResponse input').removeAttr('checked');
        }
    });
    $(".table-col-line input[type=checkbox]").live("click", function(){
        if ($(this).is(":checked")) {
            $(this).parents(".table-col-line").addClass("active");
        } else {
            $(this).parents(".table-col-line").removeClass("active");
        }
    });
});